/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.client;

import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.util.text.Color;
import net.minecraftforge.common.ForgeConfigSpec;
import net.smileycorp.hordes.common.Hordes;

public class ClientConfigHandler {
    public static final ForgeConfigSpec.Builder builder = new ForgeConfigSpec.Builder();
    public static final ForgeConfigSpec config;
    private static Color hordeMessageColour;
    private static java.awt.Color zombiePlayerColour;
    private static java.awt.Color drownedPlayerColour;
    public static ForgeConfigSpec.ConfigValue<Integer> eventNotifyMode;
    public static ForgeConfigSpec.ConfigValue<Integer> eventNotifyDuration;
    public static ForgeConfigSpec.ConfigValue<Boolean> hordeSpawnSound;
    private static ForgeConfigSpec.ConfigValue<List<? extends Integer>> configHordeMessageColour;
    private static ForgeConfigSpec.ConfigValue<List<? extends Integer>> configZombiePlayerColour;
    private static ForgeConfigSpec.ConfigValue<List<? extends Integer>> configDrownedPlayerColour;
    public static ForgeConfigSpec.ConfigValue<Boolean> playerInfectSound;

    public static Color getHordeMessageColour() {
        if (hordeMessageColour == null) {
            List rgb = (List)configHordeMessageColour.get();
            hordeMessageColour = rgb.size() >= 3 ? Color.func_240743_a_((int)(((Integer)rgb.get(0) << 16) + ((Integer)rgb.get(1) << 8) + (Integer)rgb.get(2))) : Color.func_240743_a_((int)0);
        }
        return hordeMessageColour;
    }

    public static java.awt.Color getZombiePlayerColour() {
        if (zombiePlayerColour == null) {
            List rgb = (List)configZombiePlayerColour.get();
            zombiePlayerColour = rgb.size() >= 3 ? new java.awt.Color((Integer)rgb.get(0), (Integer)rgb.get(1), (Integer)rgb.get(2)) : new java.awt.Color(121, 156, 101);
        }
        return zombiePlayerColour;
    }

    public static java.awt.Color getDrownedPlayerColour() {
        if (drownedPlayerColour == null) {
            List rgb = (List)configDrownedPlayerColour.get();
            drownedPlayerColour = rgb.size() >= 3 ? new java.awt.Color((Integer)rgb.get(0), (Integer)rgb.get(1), (Integer)rgb.get(2)) : new java.awt.Color(144, 255, 255);
        }
        return drownedPlayerColour;
    }

    static {
        hordeMessageColour = null;
        zombiePlayerColour = null;
        drownedPlayerColour = null;
        Hordes.logInfo("Trying to load client config");
        builder.push("Horde Event");
        eventNotifyMode = builder.comment("How do players get notified of a horde event. 0: Off, 1: Chat, 2:Action Bar, 3:Title").define("eventNotifyMode", (Object)2);
        eventNotifyDuration = builder.comment("How long in ticks does the horde notification appear? (Only applies to modes 2 and 3)").define("eventNotifyDuration", (Object)60);
        hordeSpawnSound = builder.comment("Play a sound when a horde wave spawns.").define("hordeSpawnSound", true);
        configHordeMessageColour = builder.comment("Colour of horde notification messages in the rgb format.").defineList("hordeMessageColour", (List)Lists.newArrayList((Object[])new Integer[]{135, 0, 0}), x -> (Integer)x >= 0 && (Integer)x < 256);
        configZombiePlayerColour = builder.comment("Colour tint for zombie players.").defineList("zombiePlayerColour", (List)Lists.newArrayList((Object[])new Integer[]{121, 156, 101}), x -> (Integer)x >= 0 && (Integer)x < 256);
        configDrownedPlayerColour = builder.comment("Colour tint for drowned players.").defineList("drownedPlayerColour", (List)Lists.newArrayList((Object[])new Integer[]{144, 255, 255}), x -> (Integer)x >= 0 && (Integer)x < 256);
        builder.pop();
        builder.push("Infection");
        playerInfectSound = builder.comment("Play a sound when the player beomes infected.").define("playerInfectSound", true);
        builder.pop();
        config = builder.build();
    }
}

